import React from "react";
import PT from "prop-types";
import {Route, HashRouter as Router, Switch} from "react-router-dom";

import Header from './componenets/Header/Header';

import Index from './pages/Index';
import Contacts from './pages/Contacts';
import Delivery from './pages/Delivery';
import NotFound from './pages/NotFound';


export default function App() {
    return (
        <Router>
            <Header />
            <Switch>
                <Route path="/delivery" exact component={Delivery} />
                <Route path="/contacts" exact component={Contacts} />

                <Route path="/good/:id" exact component={Index} />
                <Route path="/cart" exact component={Index} />
                <Route path="/" exact component={Index} />

                <Route component={NotFound} />
            </Switch>
        </Router>
    )
}

App.propTypes = {
    cart: PT.array,
    actions: PT.object,
};
