import React from 'react';
import PT from 'prop-types';
import get from 'lodash/get';
import { Link } from 'react-router-dom'
import { connect } from "react-redux";
import './Header.css';

const mapStateToProps = (state) => {
    return {
        cart: state.cart.cart,
        loading: state.ui.loading,
    };
};

function Header({ cart, loading }) {
    const total = get(cart, 'goods', []).map(good => good.amount * good.price).reduce((a, b) => a + b, 0);

    return (
        <div className="header">
            <div className="header__items">
                <div className="header__logo">
                    <Link to="/" className="header__logo-icon" />
                </div>
                <Link to="/delivery" className="header__link-item">Доставка</Link>
                <Link to="/contacts" className="header__link-item">Контакты</Link>
            </div>
            {!loading && (
                <Link to="/cart" className="header__cart">
                    <div className="header__cart-icon" />
                    <div className="header__cart-amount">{total} ₽</div>
                </Link>
            )}
        </div>
    );
}

Header.propTypes = {
    cart: PT.object,
    openCart: PT.func,
    loading: PT.bool,
};

export default connect(mapStateToProps)(Header);
