import React from 'react';

import './Delivery.css';

export default function Delivery() {
    return (
        <div className="delivery">
            <h1 className="delivery__header">Доставка</h1>
            <div className="delivery__desc">
                Мы отправляем заказы разными способами доставки:
                <ul>
                    <li>Почта РФ</li>
                    <li>CDEK</li>
                    <li>Boxberry</li>
                    <li>и другими курьерскими службами</li>
                </ul>
                Доставка в труднодоступные регионы или с помощью комбинированных методов
                доставки осуществляется за дополнительную плату, срок в этом случае увеличивается.<br />
                Если вы не разбираетесь в этих способах доставки, то ты можешь выбрать «оптимальный тариф» и
                мы сами подберём быстрый и недорогой способ (по соотношению: цена, скорость и качество).
            </div>

            <div className="delivery__table">
                <table>
                    <tbody>
                        <tr>
                            <th>Служба доставки</th>
                            <th>Цена</th>
                            <th>Срок доставки</th>
                            <th>Описание</th>
                        </tr>

                        <tr>
                            <td className="delivery__logo">
                                <img src={require('./img/delivery-1.jpg')} alt="" />
                            </td>
                            <td>
                                <span>Почта РФ — от 168 рублей</span>
                            </td>
                            <td>
                                <span>Срок доставки: </span>5-10 рабочих дней
                            </td>
                            <td>Государственная почта РФ. Многие пользуются и отправляют именно этим способом, потому
                                как отправить можно в любую точку страны. Отличное соотношение цена/качество.
                            </td>
                        </tr>
                        <tr>
                            <td className="delivery__logo">
                                <img src={require('./img/cdek_logo.png')} alt="" />
                            </td>
                            <td>CDEK — от 300 рублей</td>
                            <td>Срок доставки: 2-5 рабочих дней</td>
                            <td>Адреса пунктов выдачи СДЭК можно уточнить у нашего менеджера.</td>
                        </tr>
                        <tr>
                            <td className="delivery__logo">
                                <img src={require('./img/delivery-3.jpg')} alt="" />
                            </td>
                            <td>Boxberry — от 300 рублей</td>
                            <td>Срок доставки: 2-7 рабочих дней</td>
                            <td>Адреса пунктов выдачи Boxberry можно уточнить у нашего менеджера.</td>
                        </tr>
                        <tr>
                            <td className="delivery__logo">
                                <img src={require('./img/logo-pickpoint.svg')} alt="" />
                            </td>
                            <td>PickPoint постаматы — от 300 рублей</td>
                            <td>Срок доставки: 2-5 рабочих дней</td>
                            <td>Адреса постаматов PickPoint можно уточнить у нашего менеджера.</td>
                        </tr>
                        <tr>
                            <td className="delivery__logo">
                                <img src={require('./img/logo-iml.svg')} alt="" />
                            </td>
                            <td><span>IML — от 300 рублей</span></td>
                            <td>Срок доставки: 2-5 рабочих дней</td>
                            <td>Адреса пунктов выдачи IML можно уточнить у нашего менеджера.</td>
                        </tr>
                        <tr>
                            <td className="delivery__logo">
                                <img src={require('./img/logo-dpd.svg')} alt="" />
                            </td>
                            <td>DPD — от 300 рублей</td>
                            <td>Срок доставки: 2-5 рабочих дней</td>
                            <td>Адреса пунктов выдачи DPD можно уточнить у нашего менеджера.</td>
                        </tr>
                        <tr>
                            <td className="delivery__logo">
                                <img src={require('./img/logo-pec.svg')} alt="" />
                            </td>
                            <td>ПЭК — от 300 рублей</td>
                            <td>Срок доставки: 2-5 рабочих дней</td>
                            <td>Адреса пунктов выдачи ПЭК можно уточнить у нашего менеджера.</td>
                        </tr>
                        <tr>
                            <td className="delivery__logo">
                                <img src={require('./img/delivery-4.jpg')} alt="" />
                            </td>
                            <td>Доставка курьером, до двери — 368 рублей (до МКАД\КАД). За МКАД чуть дороже.</td>
                            <td>Срок доставки:
                                МСК 2-3 рабочих дня<br />
                                За МКАД 3-4 рабочих дня*<br />
                                СПБ (КАД) 3-4 рабочих дня*
                            </td>
                            <td>
                                Быстрая курьерская доставка, которая действует только в Москве и Санкт-Петербурге.<br />
                                Доставляют прямо до двери, заказ отдают лично в руки. Курьер позвонит вам за час до
                                приезда и согласует время доставки.<br />
                                Доставка будет стоить дороже, если ты находишься за пределами МКАДа И КАДа.
                            </td>
                        </tr>
                        <tr>
                            <td className="delivery__logo">
                                <img src={require('./img/ill_3.jpg')} alt="" />
                            </td>
                            <td>Международная доставка</td>
                            <td>
                                Срок доставки:<br />
                                Казахстан, Беларусь, Азербайджан, а также Ереван и Бишкек от 2 до 15 рабочих дней<br />
                                Остальные страны от 9 до 15 рабочих дней в среднем.
                            </td>
                            <td>
                                Отправляем без проблем по всему миру. Страны СНГ, Европа, Азия, Америка.
                                Как доставить в Казахстан, Беларусь, Азербайджан и города Ереван (Армения), Бишкек
                                (Киргизия) за 2-4 дня? Нужно уточнить данный способ доставки у менеджера. Возможна
                                курьерская доставка и до пунктов выдачи заказов.<br />
                                Стоимость доставки формируется после оформления заказа, так как она зависит от веса
                                посылки.&nbsp;<br />
                                Цены могу меняться в зависимости от веса заказа и удаленности страны получателя.
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    );
}
