import React from 'react';
import PT from 'prop-types';
import { connect } from 'react-redux'
import Loader from 'shared/components/Loader';
import GoodList from './components/GoodList';
import CurrentGood from './components/CurrentGood';
import Cart from "./components/Cart/Cart";
import { Route, Switch } from "react-router-dom";
import { actions } from "stores";

const mapStateToProps = state => {
    return {
        loading: state.ui.loading,
        goods: state.goods.goods,
    };
};

const mapDispatchToProps = dispatch => ({
    actions: {
        loadStart: () => dispatch(actions.ui.loadStart()),
    }
});


class Index extends React.Component {
    componentDidMount() {
        const { actions } = this.props;
        actions.loadStart();
    }

    render() {
        const { loading, goods } = this.props;

        if (loading) {
            return <Loader />;
        }

        return (
            <>
                <GoodList goods={goods} />
                <Switch>
                    <Route exact path="/good/:id" component={CurrentGood} />
                    <Route exact path="/cart" component={Cart} />
                </Switch>
            </>
        );
    }

}

Index.propTypes = {
    loading: PT.bool,
    goods: PT.array,
};

export default connect(mapStateToProps, mapDispatchToProps)(Index);
