import React from 'react';
import cn from 'classnames';
import PT from 'prop-types';
import './CartItem.css';

export default class CartItem extends React.Component {
    constructor(props) {
        super(props);
        this.handleDelete = this.handleDelete.bind(this);
    }

    handleDelete() {
        const {onDelete, id} = this.props;
        onDelete(id);
    }

    render() {
        const {img, price, amount, disabled, title} = this.props;
        return (
            <div className={cn("cart-item", {"cart-item__disabled": disabled})}>
                <div className="cart-item__img" style={{backgroundImage: `url(${img})`}} />
                <div className="cart-item__data">
                    <div className="cart-item__text">{title}</div>
                    <div className="cart-item__total">{price} ₽ x {amount} шт. = {price * amount} ₽</div>
                </div>
                <div className="cart-item__del" onClick={this.handleDelete}>
                    <div className="cart-item__del-pic" />
                </div>
            </div>
        );
    }
}

CartItem.propTypes = {
    img: PT.string,
    title: PT.string,
    id: PT.number,
    price: PT.number,
    amount: PT.number,
    onDelete: PT.func,
};
