import React from 'react';
import cn from 'classnames';
import isEqual from 'lodash/isEqual';

import './YandexPayButton.css';

export default class YandexPayButton extends React.Component {
    constructor(props) {
        super(props);
        this.ref = React.createRef()
        this.mount = this.mount.bind(this);
    }

    mount() {
        this.ref.current.innerHTML = '';

        YaPay.createPayment(this.props.paymentData).then((payment) => {
            const {onEvent} = this.props;

            const button = YaPay.Button.create({
                type: YaPay.ButtonType.Simple,
                theme: YaPay.ButtonTheme.Black,
                width: YaPay.ButtonWidth.Max,
            });

            button.mount(this.ref.current);
            button.on(YaPay.ButtonEventType.Click, async () => {
                payment.on(YaPay.PaymentEventType.Process, ({token, billingContact: {email}, paymentMethodInfo}) => {
                    onEvent({token, payment, email, paymentMethodInfo});
                });
                payment.on(YaPay.PaymentEventType.Error, (error) => onEvent({error}));
                payment.on(YaPay.PaymentEventType.Abort, (error) => onEvent({error}));

                payment.checkout()
            });
        });
    }

    componentDidMount() {
        this.mount()
    }

    componentDidUpdate(prevProps, prevState, snapshot) {
        if (!isEqual(prevProps.paymentData, this.props.paymentData)) {
            this.mount();
        }
    }

    render() {
        const {disabled} = this.props;
        return (
            <div className={cn({'ybutton-disabled': disabled})}>
                <div ref={this.ref} />
            </div>
        );
    }
}
