import React from 'react';
import {Link, Redirect} from 'react-router-dom';
import PT from 'prop-types';
import {actions} from "stores";
import {connect} from "react-redux";
import find from 'lodash/find';
import Modal from 'shared/components/Modal/Modal';

import './CurrentGood.css';

const mapStateToProps = state => {
    return {
        loading: state.cart.cartLoading,
        goods: state.goods.goods,
    };
};

const mapDispatchToProps = dispatch => ({
    actions: {
        addGoodToCart: (id) => dispatch(actions.cart.addGoodToCart(id)),
    }
});

class CurrentGood extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            close: false,
        }
        this.handleClose = this.handleClose.bind(this);
    }

    handleClose() {
        this.setState({close: true});
    }

    renderBody() {
        const {match: {params: {id}}, actions, goods, loading} = this.props;
        const good = find(goods, good => String(good.id) === id);

        if (!good) {
            return 'Товар не найден.'
        }

        const {img, title, error, price} = good;

        return (
            <div className="current-good">
                {img && <div className="current-good__img" style={{backgroundImage: `url(${img})`}} />}
                <div className="current-good__data">
                    <div className="current-good__title">{title}</div>
                    <div className="current-good__price">{price} ₽</div>
                </div>
                {error && (
                    <div className="current-good__error">{error}</div>
                )}
                <div className="current-good__button">
                    <button
                        className="button button_action button_full"
                        disabled={loading}
                        onClick={() => actions.addGoodToCart(good.id)}
                    >
                        {loading ? 'Добавляется' : 'Добавить в корзину'}
                    </button>
                </div>
                <div className="current-good__button">
                    <button onClick={this.handleClose} className="button button_full">Отмена</button>
                </div>
            </div>
        );
    }

    render() {
        const {close} = this.state;

        return (
            <Modal onRequestClose={this.handleClose} isOpen>
                {close && <Redirect to="/" />}
                {this.renderBody()}
            </Modal>
        );
    }
}


CurrentGood.propTypes = {
    img: PT.string,
    title: PT.string,
    price: PT.number,
    id: PT.number,
    onGoodAddToCart: PT.func,
    onGoodClose: PT.func,
};

export default connect(mapStateToProps, mapDispatchToProps)(CurrentGood);
