import React from 'react';
import PT from 'prop-types';
import GoodItem from './components/GoodItem/GoodItem';
import './GoodList.css';

export default function GoodList({ goods }) {
    return (
        <div className="goods-container">
            <h1 className="goods-header">Наш ассортимент</h1>
            <div className="goods">
                {goods.map((good, i) => <GoodItem key={i} {...good} />)}
            </div>
        </div>
    );
}

GoodList.propTypes = {
    goods: PT.array,
};
