import React from 'react';
import {Link} from 'react-router-dom';
import PT from 'prop-types';
import './GoodItem.css';


export default function GoodItem({id, title, price, img}) {
    return (
        <Link to={`/good/${id}`} className="good-item-box">
            <div className="good-item">
                <div className="good-item__data">
                    <div className="good-item__title">{title}</div>
                    <div className="good-item__price">{price} ₽</div>
                </div>
                <div className="good-item__img" style={{backgroundImage: `url(${img})`}} />
            </div>
        </Link>
    );
}

GoodItem.propTypes = {
    id: PT.number,
    img: PT.string,
    title: PT.string,
    price: PT.number,
};
