import React from 'react';
import ReactDOM from 'react-dom';
import Modal from 'react-modal';
import createSagaMiddleware from 'redux-saga'
import {createStore, applyMiddleware, compose} from 'redux';
import {Provider} from 'react-redux';
import {reducers, sagas} from 'stores';
import App from './app';

import '../css/reset.css';
import '../css/main.css';

let store;
const sagaMiddleware = createSagaMiddleware();

if (IS_PRODUCTION) {
    store = createStore(reducers, applyMiddleware(sagaMiddleware));
} else {
    const middleware = applyMiddleware(sagaMiddleware);
    let enhancer;

    if (window.__REDUX_DEVTOOLS_EXTENSION__) {
        // eslint-disable-line
        enhancer = compose(middleware, window.__REDUX_DEVTOOLS_EXTENSION__()); // eslint-disable-line
    } else {
        enhancer = compose(middleware);
    }

    store = createStore(reducers, enhancer);
}

function render() {
    return (
        <Provider store={store}>
            <App />
        </Provider>
    )
}

const rootElement = document.getElementById('root');
sagaMiddleware.run(sagas);

Modal.setAppElement(rootElement);
ReactDOM.render(render(), rootElement);
