import React from 'react';
import PT from 'prop-types';
import BaseModal from "react-modal";

export default function Modal({isOpen, onRequestClose, children}) {
    const customStyles = {
        content: {
            top: '0',
            left: '50%',
            right: 'auto',
            bottom: 'auto',
            transform: 'translate(-50%, 70px)',
            width: 'calc(100% - 20px)',
            maxHeight: 'calc(100% - 90px)',
            boxSizing: 'border-box',
        }
    };

    return (
        <BaseModal isOpen={Boolean(isOpen)} onRequestClose={onRequestClose} style={customStyles}>
            {children}
        </BaseModal>
    )
}

Modal.propTypes = {
    isOpen: PT.any,
    onRequestClose: PT.func,
    children: PT.node,
};
