import axios from 'axios';
import {forEach} from 'lodash';

const tokenName = document.querySelector('meta[name="csrf-param"]').getAttribute('content');
const tokenValue = document.querySelector('meta[name="csrf-token"]').getAttribute('content');

export function callApi(url, methodType = 'GET', config = {}) {
    const method = methodType.toLowerCase();

    return axios({method, url, ...config}).then(
        response => {
            if (response.status !== 200) {
                return Promise.reject(response);
            }

            return response;
        },
        error => Promise.reject(error)
    );
}

export default function apiProxy(endpoint, methodType = 'GET', data = {}, config = {}, multipartFormData = false) {
    if (!config.headers) {
        config.headers = {};
    }

    if (multipartFormData) {

        if (!(data instanceof FormData)) {
            let formData = new FormData();

            forEach(data, (value, key) => {
                if (value !== undefined) {
                    formData.append(key, value)
                }
            });

            data = formData;
        }

        Object.assign(config.headers, {'Content-Type': 'multipart/form-data'});
    }

    if (methodType === 'GET') {
        config.params = data;
    } else {
        if (config.data === null || config.data === undefined) {
            config.data = data;
        }
        config.data[tokenName] = tokenValue;
    }

    return callApi(endpoint, methodType, config)
        .then(response => {
            return ({response: response})
        })
        .catch(error => ({error}))
}
