export const available = () => {
    try {
        if ('localStorage' in window && window.localStorage !== null) {
            return true;
        }
    } catch (ignore) {
    }

    return false;
};

export default {
    set: (key, value) => {
        if (available()) {
            try {
                localStorage.setItem(key, value);
            } catch (ignoreErr) {
            }
        }
    },
    get: (key, defaultValue) => {
        defaultValue = defaultValue || null;

        if (available()) {
            try {
                return localStorage.getItem(key) || defaultValue;
            } catch (ignoreErr) {
            }
        }

        return defaultValue;
    },
};
