export async function sleep(t) {
    return new Promise((resolve) => setTimeout(resolve, t))
}

export function redirectForm(url, data, method = 'post') {
    const form = document.createElement('form');
    document.body.appendChild(form);

    form.method = method;
    form.action = url;

    for (let name in data) {
        if (data.hasOwnProperty(name)) {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = name;
            input.value = data[name];
            form.appendChild(input);
        }
    }

    form.submit();
}
