const ADD_GOOD_TO_CART = Symbol('ADD_GOOD_TO_CART');
const DELETE_FROM_CART = Symbol('DELETE_FROM_CART');
const SET_CART = Symbol('SET_CART');
const SET_CART_STATUS = Symbol('SET_CART_STATUS');
const SET_CART_PROMOCODE = Symbol('SET_CART_PROMOCODE');

const START_CART_PAYMENTS_VIA_SDK = Symbol('START_CART_PAYMENTS_VIA_SDK');
const START_CART_GOOGLE_PAY = Symbol('START_CART_GOOGLE_PAY');
const START_CART_YANDEX_PAY = Symbol('START_CART_YANDEX_PAY');

const addGoodToCart = (id) => ({type: ADD_GOOD_TO_CART, id});
const deleteFromCart = (id) => ({type: DELETE_FROM_CART, id});
const setCart = (cart) => ({type: SET_CART, cart});
const setCartStatus = (data) => ({type: SET_CART_STATUS, data});
const setCartPromocode = (promocode) => ({type: SET_CART_PROMOCODE, promocode});

const startCartPaymentsViaSDK = (email, mode, payToken) => ({type: START_CART_PAYMENTS_VIA_SDK, email, mode, payToken});
const startCartGooglePay = (email) => ({type: START_CART_GOOGLE_PAY, email});
const startCartYandexPay = (data) => ({type: START_CART_YANDEX_PAY, data});

export {
    ADD_GOOD_TO_CART,
    DELETE_FROM_CART,
    SET_CART,
    SET_CART_PROMOCODE,
    SET_CART_STATUS,

    START_CART_PAYMENTS_VIA_SDK,
    START_CART_GOOGLE_PAY,
    START_CART_YANDEX_PAY,

    addGoodToCart,
    deleteFromCart,
    setCart,
    setCartStatus,
    setCartPromocode,

    startCartPaymentsViaSDK,
    startCartGooglePay,
    startCartYandexPay,
};

export default {
    ADD_GOOD_TO_CART,
    DELETE_FROM_CART,
    SET_CART,
    SET_CART_PROMOCODE,
    SET_CART_STATUS,

    START_CART_PAYMENTS_VIA_SDK,
    START_CART_GOOGLE_PAY,
    START_CART_YANDEX_PAY,

    addGoodToCart,
    deleteFromCart,
    setCart,
    setCartStatus,
    setCartPromocode,

    startCartPaymentsViaSDK,
    startCartGooglePay,
    startCartYandexPay,
};
