import update from 'react-addons-update';
import ls from 'shared/lib/localStorage';
import cart from './actions';

const initialState = {
    cart: {
        hash: ls.get('cartHash', null),
    },
    cartShow: false,
    cartSuccess: false,
    cartError: null,
    cartLoading: null,
};


const actionsMap = {
    [cart.SET_CART]: (state, {cart}) => {
        cart = cart || {};
        ls.set('cartHash', cart.hash || '')

        return update(state, {
            cart: {$set: {...cart}}
        });
    },

    [cart.SET_CART_STATUS]: (state, {data}) => {
        const diff = {};
        for (let key in data) {
            if (data.hasOwnProperty(key)) {
                diff[key] = {$set: data[key]};
            }
        }
        return update(state, diff);
    }
};

export default (state = initialState, action = {}) => {
    const fn = actionsMap[action.type];
    return fn ? fn(state, action) : state;
};
