import update from 'react-addons-update';
import actions from './actions';

const initialState = {
    goods: [],
};


const actionsMap = {
    [actions.SET_GOODS]: (state, {goods}) => {
        return update(state, {
            goods: {$set: goods},
        });
    },

};

export default (state = initialState, action = {}) => {
    const fn = actionsMap[action.type];
    return fn ? fn(state, action) : state;
};
