import {call, put, takeEvery} from 'redux-saga/effects';
import api from 'shared/lib/api';
import goodsActions from './actions';
import uiActions from '../ui/actions';

function* loadGoods() {
    const {response} = yield call(api, '/api/goods');
    if (response) {
        yield put(goodsActions.setGoods(response.data));
        yield put(uiActions.loadFinish());
    }
}

export default [
    takeEvery(goodsActions.LOAD_GOODS, loadGoods),
];
