import {combineReducers} from 'redux';
import {all} from 'redux-saga/effects';

import goods from './goods';
import cart from './cart';
import ui from './ui';
import lpm from './lpm';

export const actions = {
    goods: goods.actions,
    cart: cart.actions,
    ui: ui.actions,
    lpm: lpm.actions,
};

export const reducers = combineReducers({
    goods: goods.reducers,
    cart: cart.reducers,
    ui: ui.reducers,
    lpm: lpm.reducers,
});

export const sagas = function* rootSaga() {
    yield all([
        ...goods.sagas,
        ...cart.sagas,
        ...ui.sagas,
        ...lpm.sagas,
    ])
};
