import update from 'react-addons-update';
import filter from 'lodash/filter';
import actions from './actions';
import get from "lodash/get";

const initialState = {
    methods: [],
};


const actionsMap = {
    [actions.SET_LPM]: (state, {methods}) => {
        return update(state, {
            methods: {$set: methods}
        });
    },
};

export default (state = initialState, action = {}) => {
    const fn = actionsMap[action.type];
    return fn ? fn(state, action) : state;
};
