import update from 'react-addons-update';
import actions from './actions';

const initialState = {
    loading: true,
};


const actionsMap = {
    [actions.LOAD_FINISH]: (state) => {
        return update(state, {
            loading: {$set: false}
        });
    },
};

export default (state = initialState, action = {}) => {
    const fn = actionsMap[action.type];
    return fn ? fn(state, action) : state;
};
