import {call, all, put, takeEvery, select} from 'redux-saga/effects';
import api from 'shared/lib/api';
import uiActions from './actions';
import goodsActions from '../goods/actions';
import cartActions from '../cart/actions';
import lpmActions from "../lpm/actions";

function* load() {
    const state = yield select()
    const hash = state.cart.cart.hash;

    const [
        {response: responseGoods},
        {response: responseCart},
    ] = yield all([
        call(api, '/api/good'),
        call(api, '/api/cart' + (hash ? `/${hash}` : '')),
    ]);

    if (responseGoods) {
        yield put(goodsActions.setGoods(responseGoods.data));
    }

    if (responseCart) {
        yield put(cartActions.setCart(responseCart.data));
    }

    yield put(lpmActions.loadLpm());
    yield put(uiActions.loadFinish());
}

export default [
    takeEvery(uiActions.LOAD_START, load),
];
