<?php

namespace app\components\clients;

use Exception;
use GuzzleHttp\Client;
use Yii;

class BaseClient
{
    /**@var Client */
    protected $client;
    /**@var string */
    protected $baseUrl;
    /**@var string */
    protected $requestId;
    /**@var boolean */
    protected $verify;

    public function __construct()
    {
        $this->client = new Client();
        $this->requestId = md5(uniqid());
    }

    protected function request($method, $path, $options)
    {
        $options = array_merge(['verify' => $this->verify, 'http_errors' => false], $options);

        $response = $this->client->request($method, $this->baseUrl . $path, $options);
        $responseContent = $response->getBody()->getContents();

        Yii::info([
            'status_code' => $response->getStatusCode(),
            'response' => $responseContent,
            'request_options' => $options,
            'url' => $this->baseUrl . $path
        ]);

        if ($response->getStatusCode() < 400) {
            return json_decode($responseContent, true);
        } else {
            $message = 'Interaction error';
            if (YII_DEBUG) {
                $message = 'Interaction error: ' . $response->getBody();
            }
            throw new Exception($message);
        }
    }

    public function get($path, $options)
    {
        return $this->request('GET', $path, $options);
    }

    public function post($path, $options)
    {
        return $this->request('POST', $path, $options);
    }
}
