<?php

namespace app\components\clients;

use Yii;
use yii\helpers\ArrayHelper;

class PaymentsClient extends BaseClient
{
    private $token;

    public function __construct()
    {
        parent::__construct();
        $this->baseUrl = ArrayHelper::getValue(Yii::$app->params, 'interactions.payments.baseUrl');
        $this->token = ArrayHelper::getValue(Yii::$app->params, 'interactions.payments.token');
        $this->verify = ArrayHelper::getValue(Yii::$app->params, 'interactions.payments.verify', true);
    }

    protected function request($method, $path, $options)
    {
        $options['headers'] = ArrayHelper::getValue($options, 'headers', []);
        $options['headers']['Authorization'] = $this->token;
        return parent::request($method, $path, $options);
    }

    public function createOrder($caption, $description, $items, $mode)
    {
        $orderItems = [];
        foreach ($items as $item) {
            $orderItems[] = [
                'name' => $item['name'],
                'price' => $item['price'],
                'nds' => $item['nds'],
                'currency' => 'RUB',
                'amount' => $item['amount'],
            ];
        }

        return $this->post('/order', [
            'json' => [
                'caption' => $caption,
                'description' => $description,
                'items' => $orderItems,
                'mode' => $mode,
            ]
        ]);
    }
}
