<?php

namespace app\components\clients;

use DateTime;
use Yii;
use yii\helpers\ArrayHelper;

class RbkClient extends BaseClient
{
    private $token;

    public function __construct()
    {
        parent::__construct();
        $this->baseUrl = ArrayHelper::getValue(Yii::$app->params, 'interactions.rbk.baseUrl');
        $this->token = ArrayHelper::getValue(Yii::$app->params, 'interactions.rbk.token');
        $this->verify = ArrayHelper::getValue(Yii::$app->params, 'interactions.rbk.verify', true);
    }

    protected function request($method, $path, $options)
    {
        $options['headers'] = ArrayHelper::getValue($options, 'headers', []);

        $options['headers']['Authorization'] ='Bearer ' . ArrayHelper::getValue($options, 'authorization', $this->token);
        $options['headers']['Content-Type'] = "application/json; charset=utf-8";
        $options['headers']['X-Request-ID'] = $this->requestId;
        return parent::request($method, $path, $options);
    }


    public function createInvoice($provider, $cart, $fingerprint)
    {
        $merchantId = '';
        switch ($provider) {
            case 'GooglePay':
                $merchantId = ArrayHelper::getValue(Yii::$app->params, 'googlePay.gatewayMerchantId', "");
                break;
            case 'YandexPay':
                $merchantId = ArrayHelper::getValue(Yii::$app->params, 'yandexPay.gatewayMerchantId', "");
                break;
        }


        $amount = 0;
        $orderItems = [];
        foreach ($cart->cartsGoods as $item) {
            $amount += ($item->amount * $item->good->price) * 100;
            $orderItems[] = [
                "product" => $item->good->title,
                "quantity" => $item->amount,
                "price" => $item->good->price * 100,
                "taxMode" => [
                    "type" => "InvoiceLineTaxVAT",
                    "rate" => "20/120"
                ]
            ];
        }

        $dueDate = new DateTime();
        $dueDate->modify('+1 day');

        $json = [
            "shopID" => $merchantId,
            "externalID" => $this->requestId,
            "dueDate" => $dueDate->format('Y-m-d\TH:i:s\Z'),
            "amount" => $amount,
            "currency" => "RUB",
            "product" => "Покупка в демомагазине Наклейки от Валерки",
            "cart" => $orderItems,
            "metadata" => ['hash' => $cart->hash]
        ];

        return $this->post('/processing/invoices', [
            'json' => $json
        ]);
    }

    public function createPaymentResource($token, $invoiceAccessToken, $provider, $fingerprint, $ip, $paymentMethodInfo)
    {
        $merchantId = '';
        switch ($provider) {
            case 'GooglePay':
                $merchantId = ArrayHelper::getValue(Yii::$app->params, 'googlePay.gatewayMerchantId', "");
                break;
            case 'YandexPay':
                $merchantId = ArrayHelper::getValue(Yii::$app->params, 'yandexPay.gatewayMerchantId', "");
                break;
        }

        $json = [
            "externalID" => md5($this->requestId),
            "paymentTool" => [
                "paymentToolType" => "TokenizedCardData",
                "provider" => $provider,
                'gatewayMerchantID' => $merchantId,
                'paymentToken' => [
                    'type' => 'process',
                    'token' => $token,
                    "paymentMethodInfo" => $paymentMethodInfo,
                ],
            ],
            "clientInfo" => [
                "fingerprint" => $fingerprint,
                "ip" => $ip
            ]
        ];

        return $this->post('/processing/payment-resources', [
            'json' => $json,
            'authorization' => $invoiceAccessToken
        ]);
    }

    public function createPayment($invoiceID, $paymentToolToken, $paymentSession, $email)
    {
        $json = [
            "externalID" => md5(md5($this->requestId)),
            "flow" => [
                "type" => "PaymentFlowInstant"
            ],
            "payer" => [
                "payerType" => "PaymentResourcePayer",
                "paymentToolToken" => $paymentToolToken,
                "paymentSession" => $paymentSession,
                "contactInfo" => [
                    "email" => $email
                ]
            ],
            "processingDeadline" => "30m",
            "makeRecurrent" => false
        ];

        return $this->post("/processing/invoices/{$invoiceID}/payments", ['json' => $json]);
    }

    public function invoiceEvents($invoiceID)
    {
        return $this->get("/processing/invoices/{$invoiceID}/events", ['query' => ['limit' => 100]]);
    }
}
