<?php

namespace app\components\controllers;

use app\components\clients\PaymentsClient;
use app\components\clients\RbkClient;
use Yii;
use yii\helpers\ArrayHelper;
use yii\web\Controller;
use yii\web\Response;

class BaseController extends Controller
{
    public $layout = false;

    /**
     * @return \yii\web\Request
     */
    public function getRequest()
    {
        return Yii::$app->request;
    }

    protected function getPaymentsClient()
    {
        return new PaymentsClient();
    }

    protected function getRbkClient()
    {
        return new RbkClient();
    }

    public function getConfigParam($key, $default = null)
    {
        return ArrayHelper::getValue(Yii::$app->params, $key, $default);
    }
}
