<?php

namespace app\controllers\api;

use app\components\controllers\ApiController;
use app\models\Cart;
use app\models\CartGood;
use app\models\Good;
use app\models\PaymentsMock;
use Exception;
use Yii;
use yii\web\NotFoundHttpException;
use yii\web\BadRequestHttpException;
use yii\web\MethodNotAllowedHttpException;
use yii\web\Response;
use yii\filters\VerbFilter;

class CartController extends ApiController
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'index' => ['GET', 'POST'],
                    'startpaymentsviasdk' => ['POST'],
                    'startgooglepay' => ['POST'],
                ],
            ],
        ];
    }

    public function beforeAction($action)
    {
        Yii::$app->response->format = Response::FORMAT_JSON;
        return parent::beforeAction($action);
    }

    public function actionIndex($hash = null)
    {
        $cart = null;

        if ($this->getRequest()->isGet) {
            if (!$hash) {
                throw new NotFoundHttpException();
            }
            $cart = Cart::findOne(['hash' => $hash]);
            if (!$cart) {
                throw new NotFoundHttpException();
            }
        } else if ($this->getRequest()->isPost) {
            $cartGoods = $this->getRequest()->post('goods');
            $promocode = $this->getRequest()->post('promocode');
            $hash = $hash ?: $this->getRequest()->post('hash');

            $db = Yii::$app->db;
            $transaction = $db->beginTransaction();

            try {
                if ($hash) {
                    $cart = Cart::findOne(['hash' => $hash]);
                }

                if (!$cart) {
                    $cart = new Cart();
                }

                if (!is_null($promocode)) {
                    $cart->promocode = $promocode;
                }

                if (!$cart->save()) {
                    throw new BadRequestHttpException("cant save cart");
                };

                if (!is_null($cartGoods)) {
                    foreach ($cart->cartsGoods as $cartGood) {
                        $cartGood->delete();
                    }

                    foreach ($cartGoods as $cartGoodItem) {
                        if (!is_array($cartGoodItem)) {
                            throw new BadRequestHttpException("good item is not array");
                        }

                        $goodId = $cartGoodItem['id'];

                        if (!is_int($goodId)) {
                            throw new BadRequestHttpException("id of good is not int ");
                        }

                        /**@var Good $good */
                        $good = Good::findOne(['id' => $goodId]);
                        if (!$good) {
                            throw new NotFoundHttpException("good #$goodId not found");
                        }

                        $cartGood = new CartGood();
                        $cartGood->cart_id = $cart->id;
                        $cartGood->good_id = $good->id;
                        $cartGood->amount = $cartGoodItem['amount'];

                        if (!$cartGood->save()) {
                            throw new BadRequestHttpException("cant save cart good");
                        };
                    }
                }

                $transaction->commit();
            } catch (Exception $e) {
                $transaction->rollBack();
                throw $e;
            }
        } else {
            throw new MethodNotAllowedHttpException();
        }


        return $this->asJson($cart->asJson());
    }

    public function actionStartpaymentsviasdk($hash)
    {
        $email = $this->getRequest()->post('email');
        $mode = $this->getRequest()->post('mode');

        $cart = Cart::findOne(['hash' => $hash]);
        if (!$cart) {
            throw new NotFoundHttpException();
        }

        $items = [];
        foreach (CartGood::findAll(['cart_id' => $cart->id]) as $cartGood) {
            $items[] = [
                'name' => $cartGood->good->title,
                'price' => $cartGood->good->price,
                'nds' => $cartGood->good->nds,
                'currency' => 'RUB',
                'amount' => $cartGood->amount,
            ];
        }

        if ($this->getConfigParam('usePaymentsMock', false)) {
            // Для отладки: можно положить в базу ответы API
            /**@var PaymentsMock $mock */
            $mock = PaymentsMock::find()->limit(1)->one();
            if (!$mock) {
                throw new NotFoundHttpException();
            }
            $data = $mock->response;
            $mock->delete();
        } else {
            // Получаем pay_token и order_id
            $caption = "Создан через миниапп";
            $data = $this->getPaymentsClient()->createOrder("Заказ #{$cart->id}", $caption, $items, $mode);
        }

        $cart->order_id = $data['data']['order_id'];
        $cart->email = $email;
        $cart->save();

        return $this->asJson([
            'id' => $cart->id,
            'email' => $email,
            'label' => "Заказ #{$cart->id}",
            'payToken' => $data['data']['pay_token'],
            'total' => $data['data']['price']
        ]);
    }


    public function actionStartgooglepay($hash)
    {
        $token = $this->getRequest()->post('token');

        $cart = Cart::findOne(['hash' => $hash]);
        if (!$cart) {
            throw new NotFoundHttpException();
        }

        $response = $this->getRbkClient()->createPaymentResource(
            json_decode($token, true),
            "GooglePay",
            md5($this->getRequest()->getUserAgent()),
            $this->getRequest()->getUserIP()
        );

        return $this->asJson($response);
    }

    public function actionStartyandexpay($hash)
    {
        $token = $this->getRequest()->post('token');
        $email = $this->getRequest()->post('email');
        $paymentMethodInfo = $this->getRequest()->post('paymentMethodInfo');
        $fingerprint = md5($this->getRequest()->getUserAgent() . '$' . $this->getRequest()->getUserIP());

        $cart = Cart::findOne(['hash' => $hash]);
        if (!$cart) {
            throw new NotFoundHttpException();
        }
        $cart->email = $email;
        $cart->save();

        // 1. Создаем invoice
        $invoice = $this->getRbkClient()->createInvoice("YandexPay", $cart, $fingerprint);

        // 2. Засылаем токен
        $paymentResource = $this->getRbkClient()->createPaymentResource(
            $token,
            $invoice['invoiceAccessToken']['payload'],
            "YandexPay",
            $fingerprint,
            $this->getRequest()->getUserIP(),
            $paymentMethodInfo
        );

        // 3. Стартуем
        $paymentResource = $this->getRbkClient()->createPayment(
            $invoice['invoice']['id'],
            $paymentResource['paymentToolToken'],
            $paymentResource['paymentSession'],
            $cart->email
        );

        return $this->asJson($paymentResource);
    }

    public function actionGetstatusyandexpay()
    {
        $invoiceID = $this->getRequest()->get('invoiceID');
        $result = $this->getRbkClient()->invoiceEvents($invoiceID);
        return $this->asJson($result);
    }
}
