<?php

namespace app\controllers\api;

use app\components\controllers\ApiController;
use app\models\Good;
use yii\filters\VerbFilter;

class GoodController extends ApiController
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'index' => ['GET'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $data = [];
        foreach (Good::find()->all() as $model) {
            $item = $model->getAttributes(['id', 'title', 'img', 'price']);
            $item['price'] = floatval($item['price']);
            $data[] = $item;
        }

        return $this->asJson($data);
    }
}
