<?php

namespace app\controllers\api;

use app\components\controllers\ApiController;
use app\models\Cart;
use Yii;
use yii\filters\VerbFilter;
use yii\helpers\ArrayHelper;

class LpmController extends ApiController
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'index' => ['GET'],
                ],
            ],
        ];
    }

    public function actionIndex($hash = null)
    {
        $data = [
            [
                'value' => 'paymentsViaSDK',
                'label' => 'Яндекс.Оплата (через PaymentsSDK)'
            ],
            [
                'hide' => true,
                'value' => 'googlePay',
                'label' => 'Google Pay',
                'external' => [
                    'src' => 'https://pay.google.com/gp/p/js/pay.js'
                ],
                'params' => [
                    'gateway' => ArrayHelper::getValue(Yii::$app->params, 'googlePay.gateway', null),
                    'gatewayMerchantId' => ArrayHelper::getValue(Yii::$app->params, 'googlePay.gatewayMerchantId', null),
                    'environment' => ArrayHelper::getValue(Yii::$app->params, 'googlePay.environment', "TEST"),
                    'merchantName' => ArrayHelper::getValue(Yii::$app->params, 'googlePay.merchantName', ""),
                    'merchantId' => ArrayHelper::getValue(Yii::$app->params, 'googlePay.merchantId', ""),
                    'allowedCardNetworks' => ["MASTERCARD", "VISA"],
                    'allowedCardAuthMethods' => ["PAN_ONLY", "CRYPTOGRAM_3DS"]
                ]
            ],
            [
                'hide' => true,
                'value' => 'applePay',
                'label' => 'Apple Pay'
            ],
            [
                'value' => 'yandexPay',
                'label' => 'Yandex Pay',
                'external' => [
                    'src' => 'https://pay.yandex.ru/sdk/v1/pay.js'
                ],
                'params' => [
                    'gateway' => ArrayHelper::getValue(Yii::$app->params, 'yandexPay.gateway', null),
                    'gatewayMerchantId' => ArrayHelper::getValue(Yii::$app->params, 'yandexPay.gatewayMerchantId', null),
                    'merchantName' => ArrayHelper::getValue(Yii::$app->params, 'yandexPay.merchantName', ""),
                    'merchantId' => ArrayHelper::getValue(Yii::$app->params, 'yandexPay.merchantId', ""),
                ],
            ]
        ];

        return $this->asJson($data);
    }
}
