<?php

use yii\db\Migration;


class m200321_210006_cart extends Migration
{
    public function safeUp()
    {
        $this->createTable('carts', [
            'id' => $this->primaryKey(),
            'email' => $this->string()->notNull(),
            'order_id' => $this->integer()->defaultValue(null),
            'created' => $this->dateTime()->notNull()->defaultExpression('NOW()'),
        ], 'ENGINE=InnoDB DEFAULT CHARSET=utf8mb4');

        $this->createTable('carts_goods', [
            'id' => $this->primaryKey(),
            'cart_id' => $this->integer()->notNull(),
            'good_id' => $this->integer()->notNull(),
            'amount' => $this->integer()->notNull(),
        ], 'ENGINE=InnoDB DEFAULT CHARSET=utf8mb4');

        $this->addForeignKey(
            'fk-carts-goods-cart_id',
            'carts_goods',
            'cart_id',
            'carts',
            'id',
            'RESTRICT'
        );

        $this->addForeignKey(
            'fk-carts-goods-good_id',
            'carts_goods',
            'good_id',
            'goods',
            'id',
            'RESTRICT'
        );
    }

    public function safeDown()
    {
        $this->dropTable('carts');
        $this->dropTable('carts_goods');
    }
}
