<?php

namespace app\models;


use app\components\BaseModel;

/**
 * This is the model class for table "carts".
 *
 * @property int $id
 * @property int $order_id
 * @property string $email
 * @property string $created
 * @property string $promocode
 * @property string $hash
 *
 * @property CartGood[] $cartsGoods
 */
class Cart extends BaseModel
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'carts';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['created'], 'safe'],
            [['email', 'promocode'], 'string', 'max' => 255],
            [['hash'], 'default', 'value' => md5(uniqid("", true))],
        ];
    }

    /**
     * Gets query for [[CartsGoods]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCartsGoods()
    {
        return $this->hasMany(CartGood::class, ['cart_id' => 'id']);
    }

    /**
     * @return array
     */
    public function asJson()
    {
        $goods = [];

        /**@var CartGood $cartGood */
        foreach ($this->getCartsGoods()->all() as $cartGood) {
            /**@var Good $good */
            $good = $cartGood->good;

            $goods[] = [
                'id' => $good->id,
                'img' => $good->img,
                'price' => floatval($good->price),
                'title' => $good->title,
                'amount' => $cartGood->amount
            ];
        }

        return [
            'id' => $this->id,
            'hash' => $this->hash,
            'promocode' => $this->promocode,
            'email' => $this->email,
            'goods' => $goods,
        ];
    }
}
