<?php

namespace app\models;

use app\components\BaseModel;

/**
 * @property int $id
 * @property int $cart_id
 * @property int $good_id
 * @property int $amount
 *
 * @property Cart $cart
 * @property Good $good
 */
class CartGood extends BaseModel
{
    public static function tableName()
    {
        return 'carts_goods';
    }

    public function rules()
    {
        return [
            [['cart_id', 'good_id', 'amount'], 'required'],
            [['cart_id', 'good_id', 'amount'], 'integer'],
            [['cart_id'], 'exist', 'skipOnError' => true, 'targetClass' => Cart::class, 'targetAttribute' => ['cart_id' => 'id']],
            [['good_id'], 'exist', 'skipOnError' => true, 'targetClass' => Good::class, 'targetAttribute' => ['good_id' => 'id']],
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getCart()
    {
        return $this->hasOne(Cart::class, ['id' => 'cart_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getGood()
    {
        return $this->hasOne(Good::class, ['id' => 'good_id']);
    }
}
