#!/bin/bash
set -exo pipefail

source config.sh

# keep this synchronized with templatemaster.conf
# unstable-eviction.maximum-time
DUE_DATE=$(date -d '2 hours ago' +%s)

seq 0 $((SHARDS_PER_HOST - 1)) | while read shard
do
    curl -m60 -w '%{url_effective} %{http_code} %{time_total}\n' "localhost:$LUCENE_INDEXER_PORT/delete?cleanup&prefix=$shard&text=created_minute:%5b0+TO+${DUE_DATE}000%5d"
done

