#!/bin/bash
set -exo pipefail


source recommended_java_args.sh
source classpath.sh
source config.sh

GB=$((1024*1024*1024))
GB1_5=$((GB + (GB/2)))
MEMORY_GAP=${MEMORY_GAP:-$GB1_5}
XMX=$((MEM_LIMIT * 4 / 5 - MEMORY_GAP))
#XMX=$((MEM_LIMIT * 1 / 5))
export CPU_CORES=$(echo $CPU_LIMIT | grep -Eo '[0-9\.]+' | awk '{print int($1)}')

export CLASS="ru.yandex.multistarter.MultiStarter"

CONSUMER_ARGS="ru.yandex.dispatcher.consumer.ConsumerServer -config consumer.conf"
PRODUCER_ARGS="ru.yandex.dispatcher.producer.Producer producer.conf"
LUCENE_ARGS="ru.yandex.msearch.Daemon -config lucene.conf"
TEMPLATEMASTER_ARGS="ru.yandex.mail.so.templatemaster.TemplateMaster templatemaster.conf"

GC_ARGS="
-XX:+DisableExplicitGC
-Xlog:gc*:/dev/shm/gc.log
-XX:+UnlockExperimentalVMOptions
-XX:+UseG1GC
-Xmx${XMX}
-Xms${XMX}
-Xmn512M
-XX:ParallelGCThreads=6
-XX:ConcGCThreads=3
-XX:G1ConcRefinementThreads=1
-XX:MaxGCPauseMillis=50
-XX:G1MixedGCCountTarget=32
-XX:G1HeapWastePercent=20
-XX:G1AdaptiveIHOPNumInitialSamples=10
-XX:+PrintGCDetails
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=/logs
"
ADDITIONAL_ARGS="-DPORTO=1 -XX:ActiveProcessorCount=$CPU_CORES -Dru.yandex.dispatcher-zk.reconnect-threads=4 -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005"

LD_LIBRARY_PATH=$JAVA_LD_LIBRARY_PATH LD_PRELOAD=$JAVA_LD_PRELOAD exec \
    $BSCONFIG_IDIR/jdk/bin/java \
    $NET_ARGS $GC_ARGS $ADDITIONAL_ARGS \
    -Djava.library.path=template_master \
    -cp $CLASSPATH \
    $CLASS $CONSUMER_ARGS ';' $PRODUCER_ARGS ';' $LUCENE_ARGS ';' $TEMPLATEMASTER_ARGS
