#!/bin/bash
set -exo pipefail

source config.sh

export WATCHDOG_QUEUE_NAME=tm_watchdog

STATUS_PORTS=(
$TEMPLATE_MASTER_PORT
$PRODUCER_PORT
$CONSUMER_PORT
)

PING_PORTS=(
$LUCENE_INDEXER_PORT
$LUCENE_DUMP_PORT
$LUCENE_SEARCH_PORT
)

end_date=$(expr $(date +%s) + 3600)
while true
do
    if [ $(date +%s) -ge $end_date ]
    then
        >&2 echo Status script timed out
        exit 1
    fi

    # Fast check clients, if any client is in any state except ACTIVE, exit 1
    # If /status is not available, probably service is not started yet,
    # just skip this check
    for status_port in ${STATUS_PORTS[@]}
    do
        if ! CURL_OPTS='-H "Connection: close"' FAIL_FAST_EXIT_CODE=0 PORT=$status_port REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
        then
            >&2 echo "Port $status_port /status check failed"
            exit 1
        fi
    done

    # Fast check, just sleep on failure
    failed=0
    for ping_port in ${PING_PORTS[@]}
    do
        if ! CURL_OPTS='-H "Connection:close"' PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
        then
            >&2 echo "Port $ping_port /ping check failed"
            failed=1
            break
        fi
    done

    if [ $failed -eq 1 ]
    then
        sleep 1
        continue
    fi

    WATCHDOG_VERSION=$(date +%s)
    code=$(curl -sm 10 -o /dev/null -w '%{http_code}' -H "ZooShardId: 0" -H "ZooQueue: $WATCHDOG_QUEUE_NAME" -H "ZooQueueId: $WATCHDOG_VERSION" --data-binary '{"prefix":'0',"docs":[]}' "http://localhost:$LUCENE_INDEXER_PORT/delete?watchdog&zoo-queue-id=$WATCHDOG_VERSION&check-copyness=false" || echo $?)
    if [ $code != 200 ]
    then
        >&2 echo "Indexation failed"
        sleep 1
        continue
    fi
    break
done

sleep 5
for status_port in ${STATUS_PORTS[@]}
do
    if ! CURL_OPTS='-H "Connection: close"' PORT=$status_port REQUEST_TIMEOUT=30 timeout 60 ./check_clients_status.sh
    then
        >&2 echo "Port $status_port /status second check failed"
        exit 1
    fi
done

failed=0
for ping_port in ${PING_PORTS[@]}
do
    if ! CURL_OPTS='-H "Connection:close"' PORT=$ping_port REQUEST_TIMEOUT=30 timeout 60 ./check_http_status.sh
    then
        >&2 echo "Port $ping_port /ping second check failed"
        exit 1
    fi
done

exit 0
