package ru.yandex.mail.so.templatemaster;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.HttpResponseSendingCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.server.async.BaseAsyncServer;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.BasicAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;

public class SimpleForwardHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncClient client;
    private final HttpHost host;
    private final BaseAsyncServer<?> server;

    public SimpleForwardHandler(
        AsyncClient client,
        HttpHost host,
        BaseAsyncServer<?> server)
    {
        this.client = client;
        this.host = host;
        this.server = server;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        org.apache.http.HttpRequest httpRequest,
        HttpContext httpContext)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public void handle(
        HttpRequest request,
        HttpAsyncExchange ex,
        HttpContext context) throws IOException, HttpException
    {
        ProxySession session = new BasicProxySession(server, ex, context);
        AsyncClient localClient = client.adjustZooHeaders(context);
        localClient.execute(
            host,
            new BasicAsyncRequestProducerGenerator(request),
            BasicAsyncResponseConsumerFactory.INSTANCE,
            session.listener().createContextGeneratorFor(localClient),
            new HttpResponseSendingCallback(session));
    }
}
