package ru.yandex.mail.so.templatemaster.cache;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.cache.async.ArrayWeigher;
import ru.yandex.cache.async.AsyncCache;
import ru.yandex.cache.async.ConcurrentLinkedHashMapAsyncStorage;
import ru.yandex.cache.async.ConcurrentLinkedHashMapAsyncStorageStater;
import ru.yandex.cache.async.ConstAsyncCacheTtlCalculator;
import ru.yandex.cache.async.StringWeigher;
import ru.yandex.cache.async.UnwrappingFutureCallback;
import ru.yandex.cache.async.WeighableWeigher;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.mail.so.templatemaster.TemplateMaster;
import ru.yandex.mail.so.templatemaster.storage.LuceneStableAsyncLoader;
import ru.yandex.mail.so.templatemaster.templates.StableTemplate;

public class StableTemplateCache {
    private final TemplateMaster server;
    private final ConcurrentLinkedHashMapAsyncStorage<String, StableTemplate[]>
        storage;
    private final AsyncCache<
        String,
        StableTemplate[],
        ProxySession,
        RuntimeException> cache;

    public StableTemplateCache(final TemplateMaster server) {
        this.server = server;
        storage =
            new ConcurrentLinkedHashMapAsyncStorage<>(
                server.config().stableTemplatesCache(),
                server.config().workers(),
                StringWeigher.INSTANCE,
                new ArrayWeigher<>(WeighableWeigher.INSTANCE));
        cache =
            new AsyncCache<>(
                storage,
                new ConstAsyncCacheTtlCalculator(3600000L),
                new LuceneStableAsyncLoader(server));
        server.registerStater(
            new ConcurrentLinkedHashMapAsyncStorageStater(
                storage,
                false,
                "stable-cache-status-",
                "cache",
                null));
    }

    public void get(
        String domain,
        ProxySession session,
        FutureCallback<StableTemplate[]> callback)
    {
        cache.get(
            domain,
            session,
            new UnwrappingFutureCallback<>(
                callback,
                server.stableCacheHits(),
                session.logger()));
    }

    public void drop(String domain) {
        storage.remove(domain);
    }
}
