package ru.yandex.mail.so.templatemaster.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.IntegerMemorySizeParser;

public class EvictionConfig {
    private static final long HOUR = 3600 * 1000;
    public static final EvictionConfig DEFAULT =
        new EvictionConfig(24 * HOUR, 240 * HOUR, (1 << 20) * 5);

    private final long guaranteedTime;
    private final long maximumTime;
    private final int maximumSize;

    EvictionConfig(
        final long guaranteedTime,
        final long maximumTime,
        final int maximumSize)
    {
        this.guaranteedTime = guaranteedTime;
        this.maximumTime = maximumTime;
        this.maximumSize = maximumSize;
    }

    EvictionConfig(IniConfig raw, EvictionConfig defaults)
    throws ConfigException
    {
        guaranteedTime = raw.get(
            "guaranteed-time",
            defaults.guaranteedTime(),
            DurationParser.LONG);
        maximumTime = raw.get(
            "maximum-time",
            defaults.maximumTime(),
            DurationParser.LONG);
        maximumSize = raw.get(
            "maximum-size",
            defaults.maximumSize(),
            IntegerMemorySizeParser.INSTANCE);
    }

    public long guaranteedTime() {
        return guaranteedTime;
    }

    public long maximumTime() {
        return maximumTime;
    }

    public int maximumSize() {
        return maximumSize;
    }
}
