package ru.yandex.mail.so.templatemaster.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableTemplateMasterConfig
    extends ImmutableUniversalSearchProxyConfig
    implements TemplateMasterConfig
{
    private final ImmutableHttpHostConfig producerAsyncClientConfig;
    private final ImmutableHttpHostConfig luceneIndexConfig;
    private final ImmutableHttpHostConfig luceneSearchConfig;
    private final int numShards;
    private final long searchFailoverDelay;
    private final long stableTemplateCache;
    private final long unstableTemplatesCache;
    private final EvictionConfig eviction;
    private final double matchingThreshold;
    private final int hitsToStabilize;
    private final int indexingTagsCutoffThreshold;

    public ImmutableTemplateMasterConfig(TemplateMasterConfig config)
    throws ConfigException
    {
        super(config);
        this.producerAsyncClientConfig =
            new ImmutableHttpHostConfig(config.producerAsyncClientConfig());
        this.luceneIndexConfig =
            new ImmutableHttpHostConfig(config.luceneIndexConfig());
        this.luceneSearchConfig =
            new ImmutableHttpHostConfig(config.luceneSearchConfig());
        this.numShards = config.numShards();
        this.searchFailoverDelay = config.searchFailoverDelay();
        this.stableTemplateCache = config.stableTemplatesCache();
        this.eviction = config.eviction();
        this.matchingThreshold = config.matchingThreshold();
        this.unstableTemplatesCache = config.unstableTemplatesCache();
        this.hitsToStabilize = config.hitsToStabilize();
        this.indexingTagsCutoffThreshold =
            config.indexingTagsCutoffThreshold();
    }

    @Override
    public ImmutableHttpHostConfig producerAsyncClientConfig() {
        return producerAsyncClientConfig;
    }

    @Override
    public ImmutableHttpHostConfig luceneIndexConfig() {
        return luceneIndexConfig;
    }

    @Override
    public ImmutableHttpHostConfig luceneSearchConfig() {
        return luceneSearchConfig;
    }

    @Override
    public int numShards() {
        return numShards;
    }

    @Override
    public long searchFailoverDelay() {
        return searchFailoverDelay;
    }

    @Override
    public long stableTemplatesCache() {
        return stableTemplateCache;
    }

    @Override
    public EvictionConfig eviction() {
        return eviction;
    }

    @Override
    public double matchingThreshold() {
        return matchingThreshold;
    }

    @Override
    public long unstableTemplatesCache() {
        return unstableTemplatesCache;
    }

    @Override
    public int hitsToStabilize() {
        return hitsToStabilize;
    }

    @Override
    public int indexingTagsCutoffThreshold() {
        return indexingTagsCutoffThreshold;
    }
}
