package ru.yandex.mail.so.templatemaster.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfig;

public interface TemplateMasterConfig extends UniversalSearchProxyConfig {
    HttpHostConfig producerAsyncClientConfig();

    HttpHostConfig luceneIndexConfig();

    HttpHostConfig luceneSearchConfig();

    int numShards();

    long searchFailoverDelay();

    long stableTemplatesCache(); // size in bytes of RM RAM cache

    long unstableTemplatesCache(); // size in bytes of RM RAM cache

    EvictionConfig eviction(); // policy params for domain-level eviction

    double matchingThreshold(); // How much in common mains in a template have

    int hitsToStabilize(); // Number of mails to create pattern from

    int indexingTagsCutoffThreshold(); // Only first ~ tokens are indexing
}
