package ru.yandex.mail.so.templatemaster.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;


public final class TemplateMasterConfigBuilder
    extends AbstractTemplateMasterConfigBuilder<TemplateMasterConfigBuilder>
{
    public TemplateMasterConfigBuilder() {
        super(TemplateMasterConfigDefaults.INSTANCE);
    }

    public TemplateMasterConfigBuilder(final TemplateMasterConfig config) {
        super(config);
    }

    public TemplateMasterConfigBuilder(final IniConfig config)
    throws ConfigException
    {
        super(config, TemplateMasterConfigDefaults.INSTANCE);
    }

    public TemplateMasterConfigBuilder(
        final IniConfig config,
        final TemplateMasterConfig defaults)
    throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public TemplateMasterConfigBuilder self() {
        return this;
    }

    public ImmutableTemplateMasterConfig build() throws ConfigException {
        return new ImmutableTemplateMasterConfig(this);
    }
}
