package ru.yandex.mail.so.templatemaster.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigDefaults;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;

public class TemplateMasterConfigDefaults
    extends UniversalSearchProxyConfigDefaults
    implements TemplateMasterConfig
{

    public static final TemplateMasterConfig INSTANCE =
        new TemplateMasterConfigDefaults();

    protected TemplateMasterConfigDefaults() {
    }

    @Override
    public String name() {
        return "Sherlock";
    }

    @Override
    public HttpHostConfig producerAsyncClientConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig luceneIndexConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public HttpHostConfig luceneSearchConfig() {
        return HttpHostConfigDefaults.INSTANCE;
    }

    @Override
    public int numShards() {
        return 2;
    }

    @Override
    public long searchFailoverDelay() {
        return 300;
    }

    @Override
    public long stableTemplatesCache() {
        return 0;
    }

    @Override
    public long unstableTemplatesCache() {
        return 0;
    }

    @Override
    public EvictionConfig eviction() {
        return EvictionConfig.DEFAULT;
    }

    @Override
    public double matchingThreshold() {
        return 0.8;
    }

    @Override
    public int hitsToStabilize() {
        return 10;
    }

    @Override
    public int indexingTagsCutoffThreshold() {
        return 8192;
    }
}
