package ru.yandex.mail.so.templatemaster.indexing;

import java.io.IOException;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.BasicProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.NByteArrayEntityAsyncConsumer;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.mail.so.templatemaster.TemplateMaster;

// LUCENE-SPECIFIC
public class SaveTemplateHandler
    implements HttpAsyncRequestHandler<HttpEntity>
{
    private final TemplateMaster server;

    public SaveTemplateHandler(TemplateMaster server) {
        this.server = server;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpEntity> processRequest(
        HttpRequest r,
        HttpContext c)
    {
        return new NByteArrayEntityAsyncConsumer();
    }

    @Override
    public void handle(
        HttpEntity payload,
        HttpAsyncExchange exchange,
        HttpContext context) throws IOException, HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        String dropDomain = session.params().getOrNull("drop_domain");
        if (dropDomain != null) {
            server.stableCache().drop(dropDomain);
        }
        AsyncClient client =
            server.luceneIndexClient().adjustZooHeaders(session.context());
        client.execute(
            server.config().luceneIndexConfig().host(),
            new BasicAsyncRequestProducerGenerator("/modify", payload),
            EmptyAsyncConsumerFactory.ANY_GOOD,
            session.listener().createContextGeneratorFor(client),
            new BasicProxySessionCallback(session));
    }
}
