package ru.yandex.mail.so.templatemaster.searching;

import java.util.concurrent.Executor;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.ExecutorFutureCallback;
import ru.yandex.http.util.nio.ByteArrayProcessableAsyncConsumer;
import ru.yandex.mail.so.templatemaster.TemplateMaster;

public class LocalMatchHandler
    implements HttpAsyncRequestHandler<ByteArrayProcessable>
{
    private final TemplateMaster server;
    private final Executor threadPool;

    public LocalMatchHandler(
        TemplateMaster server,
        Executor threadPool)
    {
        this.server = server;
        this.threadPool = threadPool;
    }

    @Override
    public HttpAsyncRequestConsumer<ByteArrayProcessable> processRequest(
        HttpRequest request,
        HttpContext context) throws BadRequestException
    {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Payload expected");
        }
        return new ByteArrayProcessableAsyncConsumer();
    }

    @Override
    public void handle(
        final ByteArrayProcessable bytes,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        ProxySession session =
            new BasicProxySession(server, exchange, context);
        String domain = session.params().getString("domain");

        server.stableCache().get(
            domain,
            session,
            new ExecutorFutureCallback<>(
                new TemplatesMatchingCallback(
                    session,
                    server,
                    bytes,
                    domain),
                session,
                threadPool));
    }
}
