package ru.yandex.mail.so.templatemaster.storage;

import java.io.IOException;

import org.apache.http.entity.ContentType;

import ru.yandex.http.util.nio.NByteArrayEntityGenerator;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.mail.so.templatemaster.templates.BaseTemplate;
import ru.yandex.mail.so.templatemaster.templates.StableTemplate;
import ru.yandex.util.string.StringUtils;

public class LuceneStableAsyncIndexer {
    public static NByteArrayEntityGenerator prepareIndexRequest(
        StableTemplate template,
        String domain,
        int shard)
    {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = JsonType.DOLLAR.create(sbw)) {
            writer.startObject();
            writer.key("prefix");
            writer.value(shard);
            writer.key("docs");
            writer.startArray();
            writer.startObject();
            writer.key("url");
            writer.value(template.stableSign());
            writer.key("tokens");
            writer.value(BaseTemplate.hashesToString(template.tokens()));
            writer.key("group");
            writer.value("stable_" + domain);
            writer.key("attributes");
            writer.value(template.attributes());
            writer.key("last_access");
            writer.value(template.lastAccess());
            writer.endObject();
            writer.endArray();
            writer.endObject();
        } catch (IOException e) {
            // Impossible
            throw new RuntimeException(e);
        }
        return new NByteArrayEntityGenerator(
            StringUtils.getUtf8Bytes(sbw.toString()),
            ContentType.APPLICATION_JSON);
    }

    public static NByteArrayEntityGenerator prepareUpdateLastAccessRequest(
        StableTemplate template,
        String shard)
    {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = JsonType.DOLLAR.create(sbw)) {
            writer.startObject();
            writer.key("prefix");
            writer.value(shard);
            writer.key("docs");
            writer.startArray();
            writer.startObject();
            writer.key("url");
            writer.value(template.stableSign());
            writer.key("last_access");
            writer.value(template.lastAccess());
            writer.endObject();
            writer.endArray();
            writer.endObject();
        } catch (IOException e) {
            // Impossible
            throw new RuntimeException(e);
        }
        return new NByteArrayEntityGenerator(
            StringUtils.getUtf8Bytes(sbw.toString()),
            ContentType.APPLICATION_JSON);
    }
}
