package ru.yandex.mail.so.templatemaster.storage;

import java.io.IOException;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;

import ru.yandex.collection.LongList;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.mail.so.templatemaster.TemplateMaster;
import ru.yandex.mail.so.templatemaster.templates.BaseTemplate;
import ru.yandex.mail.so.templatemaster.templates.UnstableTemplate;

public class LuceneUnstableAsyncIndexer {
    private final TemplateMaster server;

    public LuceneUnstableAsyncIndexer(final TemplateMaster server) {
        this.server = server;
    }

    public void deleteUnstableTemplates(
        final ProxySession session,
        final String params,
        final long prefix,
        final LongList urls)
    {
        int size = urls.size();
        StringBuilder sb = new StringBuilder("{\"prefix\":");
        sb.append(prefix);
        sb.append(",\"docs\":[");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append("{\"url\":");
            sb.append(urls.getLong(i));
            sb.append('}');
        }
        sb.append(']');
        sb.append('}');
        String uri =
            "/delete?" + params + "&prefix=" + prefix + "&size=" + size;
        session.logger().info("Deleting from storage: " + uri);
        indexLucene(
            session,
            sb.toString(),
            uri,
            EmptyFutureCallback.INSTANCE);
    }

    public void putUnstableTemplate(
        UnstableTemplate template,
        ProxySession session,
        boolean dumpTokens,
        FutureCallback<? super Void> callback)
    {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = JsonType.DOLLAR.create(sbw)) {
            writer.startObject();
            writer.key("prefix");
            writer.value(session.params().getOrNull("shard"));
            writer.key("docs");
            writer.startArray();
            writer.startObject();
            writer.key("url");
            writer.value(template.url());
            if (dumpTokens) {
                writer.key("tokens");
                writer.value(BaseTemplate.hashesToString(template.tokens()));
            }
            writer.key("group");
            writer.value("unstable_" + session.params().getOrNull("domain"));
            writer.key("attributes");
            writer.value(template.attributes());
            writer.key("created");
            writer.value(template.created());
            writer.key("hits");
            writer.value(template.hits());
            writer.key("len_sum");
            writer.value(template.lenSum());
            writer.endObject();
            writer.endArray();
            writer.endObject();
        } catch (IOException e) {
            callback.failed(e);
            return;
        }
        String body = sbw.toString();
        session.logger().fine(
            "Lucene document prepared, body length = " + body.length());
        indexLucene(session, body, "/modify", callback);
    }

    private void indexLucene(
        ProxySession session,
        String payload,
        String handle,
        FutureCallback<? super Void> callback)
    {
        AsyncClient client =
            server.luceneIndexClient().adjustZooHeaders(session.context());
        client.execute(
            server.config().luceneIndexConfig().host(),
            new BasicAsyncRequestProducerGenerator(
                handle,
                payload,
                ContentType.APPLICATION_JSON),
            EmptyAsyncConsumerFactory.ANY_GOOD,
            session.listener().createContextGeneratorFor(client),
            callback);
    }
}
