package ru.yandex.mail.so.templatemaster.templates;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;

import ru.yandex.jni.digest.JniDigest;
import ru.yandex.util.string.HexStrings;
import ru.yandex.util.string.UnhexStrings;

public class Digest {
    protected final int[] sortedHashes;

    public Digest(int[] sortedHashes) {
        this.sortedHashes = sortedHashes;
    }

    public static Digest fromTokens(long[] tokens) {
        int[] hashes = new int[tokens.length];
        int pos = 0;
        for (long token : tokens) {
            if (token != BaseTemplate.SEP_TOKEN) {
                hashes[pos++] =
                    (int) ((token ^ (token >> 32)) & Integer.MAX_VALUE);
            }
        }
        hashes = Arrays.copyOf(hashes, pos);
        Arrays.sort(hashes);
        return new Digest(hashes);
    }

    public static Digest parse(String s) {
        byte[] bytes = UnhexStrings.unhex(s);
        IntBuffer buf = ByteBuffer.wrap(bytes).asIntBuffer();
        int[] array = new int[buf.remaining()];
        buf.get(array);
        return new Digest(array);
    }

    public int commonHashes(Digest other) {
        return JniDigest.commonHashes(sortedHashes, other.sortedHashes);
    }

    @Override
    public String toString() {
        ByteBuffer buf = ByteBuffer.allocate(sortedHashes.length * 4);
        buf.asIntBuffer().put(sortedHashes);
        return HexStrings.UPPER.toString(buf.array());
    }
}
