package ru.yandex.mail.so.templatemaster.templates;

/**
 * Competed template, available for matching
 */
public class StableTemplate extends BaseTemplate {
    private final long stableSign;
    private volatile long lastAccess;

    public StableTemplate(
        final long[] tokens,
        final long stableSign,
        final String attributes,
        final long lastAccess)
    {
        super(
            tokens,
            attributes,
            110 + attributes.length() * 2 + tokens.length * 8);
        this.stableSign = stableSign;
        this.lastAccess = lastAccess;
    }

    public long stableSign() {
        return stableSign;
    }

    public long lastAccess() {
        return lastAccess;
    }

    public void lastAccess(long lastAccess) {
        this.lastAccess = lastAccess;
    }
}

