#include <yplatform/loader.h>

#include <library/cpp/getopt/last_getopt.h>
#include <util/system/progname.h>

#include <iostream>

int main(int argc, char* argv[]) {
    using namespace NLastGetopt;

    auto opts = TOpts::Default();
    opts.AddHelpOption();
    opts.SetFreeArgsNum(1);
    opts.SetFreeArgTitle(0, "config.yml", "config file");

    size_t freeArgPos = 1;
    try {
        freeArgPos = TOptsParseResultException(&opts, argc, argv).GetFreeArgsPos();
    } catch (const TUsageException& e) {
        std::cerr << "Can't parse options: " << e.what() << std::endl;
        opts.PrintUsage(GetProgramName());
        exit(1);
    }

    return yplatform_start(argv[freeArgPos]);
}
