#pragma once
#include <mail/sharpei_client/include/sharpei_client/sharpei_client.h>
#include <mail/sharpei_client/include/sharpei_client/http.h>
#include <mail/pgg/include/pgg/service/resolver.h>
#include <mail/yreflection/include/yamail/data/reflection/reflection.h>
#include <ozo/connection_pool.h>

namespace NTemplateMaster::NDatabase {

using TConnectionPoolConfig = ozo::connection_pool_config;

struct TSharpeiConfig {
    yplatform::time_traits::milliseconds ConnectionTimeout;
    yplatform::time_traits::milliseconds CacheTtl;
    ::sharpei::client::Settings SharpeiClientSettings;
};

struct TConfig {
    std::string User;
    std::string QueryConf;
    ozo::time_traits::duration RequestTimeout;
    TSharpeiConfig SharpeiConfig;
    TConnectionPoolConfig ConnectionPoolConfig;
};
}

YREFLECTION_ADAPT_ADT(ozo::connection_pool_config,
    YREFLECTION_WO_MEMBER(std::size_t, capacity)
    YREFLECTION_WO_MEMBER(std::size_t, queue_capacity)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, idle_timeout_ms, std::chrono::milliseconds, idle_timeout)
)

BOOST_FUSION_ADAPT_STRUCT(sharpei::client::http::Address,
    host,
    port
)

YREFLECTION_ADAPT_ADT(sharpei::client::Settings,
    YREFLECTION_WO_MEMBER_RENAMED(sharpei::client::http::Address, address, sharpeiAddress)
    YREFLECTION_WO_MEMBER(unsigned, retries)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, timeout_ms, std::chrono::milliseconds, timeout)
    YREFLECTION_WO_MEMBER_RENAMED(bool, keep_alive, keepAlive)
)

YREFLECTION_ADAPT_ADT(NTemplateMaster::NDatabase::TSharpeiConfig,
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, connect_timeout_ms,
                yplatform::time_traits::milliseconds, ConnectionTimeout)
        YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, cache_ttl_ms,
                yplatform::time_traits::milliseconds, CacheTtl)
    YREFLECTION_WO_MEMBER_RENAMED(sharpei::client::Settings, client, SharpeiClientSettings)
)

YREFLECTION_ADAPT_ADT(NTemplateMaster::NDatabase::TConfig,
    YREFLECTION_WO_MEMBER_RENAMED(std::string, user, User)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, query_conf, QueryConf)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, request_timeout_ms, std::chrono::milliseconds, RequestTimeout)
    YREFLECTION_WO_MEMBER_RENAMED(NTemplateMaster::NDatabase::TSharpeiConfig, sharpei, SharpeiConfig)
    YREFLECTION_WO_MEMBER_RENAMED(NTemplateMaster::NDatabase::TConnectionPoolConfig, connection_pool, ConnectionPoolConfig)
)


